string GetDescription()
{
	return "Renders the harmony into a boogie woogie syle accompaniament";
}

void Render(RenderPart @p)
{
	Time t = CreateTime(p.GetStartBar(), 0);
	double delta;
	
	if (p.GetTempo() > 110) delta = 0.5;
	else if (p.GetTempo() < 100) delta = 0.25;
	else
	{
		if (RndInt(0,1) == 0) delta = 0.25;
		else delta = 0.5;	
	}
	
	int[] scale = { 0, 7, 2, 3, 3, 4, -3, 4 };
	int[] diat_off = { 0, 0, 0, 0, 1, 0, 0, 0 };
	
	int note = 0;
	int old_nhp = -1;
	
	double delta_mult = RndFloat(0.5, 1.0);
	if (RndInt(0,1) == 0) delta_mult = 0.95;
	
	while (t.m_Bar < p.GetEndBar())
	{
		int nhp = p.GetHarmonicEventPitch(p.GetHarmonic(t),0);
		if (nhp != old_nhp)
		{
			note = 0;
			old_nhp = nhp;	
		}
		
		Time t2;
		t2.m_Bar = t.m_Bar;
		t2.m_Pos = t.m_Pos + delta*delta_mult; 
		
		p.AddNote(t, t2, p.AlignPitch(p.GetHarmonicEventPitch(p.GetHarmonic(t),0), scale[note])+diat_off[note] ,127);	
				
		note = (note + 1) % 8;
		
		t.m_Pos += delta;
		if (t.m_Pos >= p.GetUniquePart().GetMetrum())
		{
			t.m_Bar++;
			t.m_Pos = 0;	
			note = 0;
		}
	}
}
